<?php
/*
Plugin Name: RichWP SEO
Description: Native Gutenberg document panel for custom page title, meta description, and schema JSON-LD with presets. Always visible, lightweight and secure.
Version: 1.0.0
Author: Felix Krusch
License: GPL-2.0+
*/

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Include required classes
require_once plugin_dir_path(__FILE__) . 'includes/class-meta-handler.php';
require_once plugin_dir_path(__FILE__) . 'includes/class-frontend.php';
require_once plugin_dir_path(__FILE__) . 'includes/class-admin.php';

/**
 * Main RichWP SEO Plugin Class
 */
class RichWP_SEO_Plugin {

    /**
     * Initialize the plugin.
     */
    public static function init() {
        // Initialize components
        RichWP_SEO_Meta_Handler::init();
        RichWP_SEO_Frontend::init();
        RichWP_SEO_Admin::init();
    }
}

// Initialize the plugin
RichWP_SEO_Plugin::init();

// Set activation time for donation notice delay
register_activation_hook(__FILE__, function() {
    update_option('richwp_seo_activation_time', time());
});